/*
    $Id: cled.h,v 2.5 90/08/26 11:33:56 sw Exp $
*/
/*
    This should be set, if compiling as line discipline, in the command line
*/

#ifndef M_KERNEL
#   define M_KERNEL	0
#endif

/*
    These are booleans and describe the environment in which CLED
    is compiled and run. Even if you are on a 386 with a Unix that
    has sptalloc()/sptfree() you will normally not want to use it,
    because it allocates memory in page (4096 bytes) chunks.
*/

#define M_I386		1	/* Running on a 386 ?			*/
#define M_UNIX		1	/* System V/SCO Unix ? (or Xenix?)	*/
#define M_ATT		1	/* AT&T flavour of System V ?		*/
#define M_SPTALLOC	0	/* Kernel has, and we should use, it	*/

/*
    These are boolean options.  DEBUG should normally be 0.  The code
    compiled in if CLEDIO is true is large; if you don't need to change
    the default terminal capabilities and key bindings, set it to 0.
    BREAKTHRU compiles in a nother large chunk of code that will
    automatically reprint the current line if a write to the tty garbles
    it.  You should normally set this to 0 and just explicitly request a
    redraw in the rare event this happens.  MULTILB will dynamically
    allocate a separate history buffer per process, not just one per
    tty.  This is usually not what you want, and makes code and data
    space grow.
*/

#define DEBUG		0	/* Compile in debugging helps		*/

#define CLEDIO		1	/* Include ioctls to change defaults ?	*/
#define BREAKTHRU	0	/* Auto reprint on broadcasts ?		*/
#define MULTILB		0	/* Separate history per process ?	*/
#define VERBOSE		0	/* Print a msg each time CLED opens	*/

#define COLUMNS		80	/* Default number of columns		*/

/*
    These set sizes of various buffers. Suitable values depend on the
    amount of memory you want to devote to CLED, and its availability.
    For a 386 you may want these to be 1024,32,134,64, and for a 286
    they may be 256,16,82,64.
*/

#define MAXPROMPT	16	/* Size of prompt buffer		*/
#define MAXLINE		132	/* Size of command line buffer		*/
#define MAXHISTORY	1024	/* Size of history buffer		*/
#if !M_SPTALLOC
#   define TCAP_SIZE	64	/* max length of all terminal escapes	*/
#endif

/* End of user adjustable parameters */

/*
    Under which termio conditions CLED will operate
*/

#define CLEDOFF(flags)	(((flags) & CLEDFLAGS) != CLEDFLAGS)

#if 0
#if M_KERNEL
#   undef MULTILB
#   undef M_SPTALLOC
#   define M_SPTALLOC	0
#   define MULTILB	0
#   if !defined(TCAP_SIZE)
#	define TCAP_SIZE	64
#   endif
#endif
#endif

#define LD_DONE	    0x0001	/* flag indicating read complete	*/
#define LD_QUIT	    0x0002	/* completed under QUIT char		*/
#define LD_INTR     0x0004	/* completed under INTR char		*/
#define LD_EOF	    0x0008	/* completed under EOF			*/
#define LD_DIRTY    0x0010	/* command buffer has been changed	*/
#define LD_INSERT   0x0020	/* insert mode				*/

#define TB_NOLINE   0x0001	/* not using this discipline		*/
#define TB_OPEN	    0x0002	/* tty buff is open			*/
#define TB_READING  0x0004	/* read currently in progress		*/
#define TB_WRITING  0x0008	/* write currently in progress		*/
#define TB_INSERT   0x0010	/* insert mode				*/
#define TB_OVERUN   0x0020	/* input buffer overrun			*/
#define TB_OPENING  0x0040	/* tty buf is opening			*/
#define TB_FLUSHIT  0x0080	/* flush the input que			*/

/*
    if last flag is greater than 0x8000, change flags from short to long
*/

#ifdef M_I386
#   pragma pack(1)
#endif

struct led_buf
{
#if MULTILB
    struct led_buf          *next;
    struct led_buf          *last;
    struct proc             *proc;
#endif

    struct tty_buf          *tbp;	/* Tty buf that owns us		*/

    unchar                  prompt[MAXPROMPT+1]; /* +1: Final '\0'	*/
    unchar                  promptlen;	/* Current length of prompt	*/

    unchar		    line[MAXLINE+2]; /* +2: Left&right mark	*/
    unchar                  *lineend;	/* End of line in buf		*/
    unchar                  *lcurs;	/* Start of gap in buf		*/
    unchar                  *rcurs;	/* End of gap in buf		*/
    unchar                  *owed;	/* Part of line left over	*/

    int			    current;	/* Cursor position		*/
    int			    lastchar;	/* Last char in line buf	*/

    unchar                  history[MAXHISTORY+1]; /* +1: Final '\0'	*/
    unchar                  *historyend;/* End of history buffer	*/
    int                     lastline;	/* Last line in history buf	*/
    int                     matchlen;	/* Length of match string	*/

    unsigned		    flags;
    unsigned		    state;

    unchar                  c;		/* Character being input	*/

#if MULTILB
    int			    pid;
    int			    ppid;
#endif
};

#ifdef M_I386
#   pragma pack()
#endif

struct tty_buf
{
    struct tty_buf          *next;
    struct tty_buf          *last;

    struct led_buf          *lbp;	/* Pointer to line buffer	*/
    struct tty              *ttyp;	/* The tty we are serving	*/

    int			    cols;	/* Terminal line width		*/

    unsigned		    iflag;
    unsigned		    oflag;
    unsigned		    lflag;
    unsigned		    cflag;
    char		    cc[NCC + 2];

    unsigned		    flags;
    char		    dorefresh;	/* Refresh current line soon	*/
    char		    readsleep;	/* Sleeping while reading	*/

    struct clist	    broadcast;

    /*
	Keyboard map, and terminal capability index and table
	for this tty.
    */
    unchar		    keymap[CLEKEY_MAX];

    char		    *tcap[TCAP_COUNT];

    int			    tclen;
#if M_SPTALLOC
    unchar		    *tcstrings;
#else
    unchar		    tcstrings[TCAP_SIZE];
#endif
};

#if M_SPTALLOC && M_KERNEL
#   if M_UNIX
	extern caddr_t	*sptalloc(/* int pages,int mode,int base,int flag */);
	extern void	sptfree(/* char *va,int npages,int freeflag */);

#	define Sptalloc(bytes)	    sptalloc(btopt(bytes),PG_P,0,0)
#	define Sptfree(addr,bytes)  sptfree(addr,btopt(bytes),1)
#   else
#	define Sptalloc(bytes)	    sptalloc(bytes)
#	define Sptfree(addr,bytes)  sptfree(addr,bytes,1)
#   endif
#else
#   if !M_KERNEL
#	define Sptalloc(size)	    malloc(size)
#	define Sptfree(addr,size)   free(addr)
#   endif
#endif
