#include <sys/types.h>
#include <sys/tty.h>

#if defined(M_UNIX)
#include <sys/termio.h>
#endif

#include <stdio.h>
#include <fcntl.h>

#include <sys/cledio.h>
#include "cled.h"

FILE                    *ofp;
int                     clp;

struct cle_stats        stats;

main(argc,argv)
    int                     argc;
    unchar                  *argv[];
{
    int                     cnt;
    unchar                  *mem,*ttys;
    struct led_buf          *lb,*lbtop;
    struct tty_buf          *tbp,*tbtop;
    struct cle_buf          *cb;

    if (argc < 2)
    {
	fprintf(stderr,"Useage: cleddump output_file\n");
	exit(1);
    }
    clp = open("/dev/cled",O_RDWR);
    if (clp < 0)
    {
	perror("Unable to open /dev/cled");
	exit(1);
    }
    ofp = fopen(argv[1],"w");
    if (ofp == 0)
    {
	perror("Unable to open output file");
	exit(1);
    }
    if (ioctl(clp,LDGETS,&stats) < 0)
    {
	perror("Error doing LDGETS ioctl");
	exit(1);
    }
    fprintf(ofp,"Max ledbufs = %d, Max ttybufs = %d, ledbufs used = %d\n",
	stats.ledbufs,stats.ttybufs,stats.ledbufs_used);
    fprintf(ofp,"ttybufs used = %d, Line number = %d\n\n",
	stats.ttybufs_used,stats.line);
    mem = (unchar *) malloc(sizeof (struct cle_buf) +
	stats.ledbufs * sizeof (struct led_buf) +
	stats.ttybufs * sizeof (struct tty_buf));
    ttys = (unchar *) malloc(sizeof (struct tty));
    if (ioctl(clp,LDGETB,mem) < 0)
    {
	perror("Error doing LDGETB");
	exit(1);
    }
    cb = (struct cle_buf *) mem;
    lbtop = lb = (struct led_buf *) (cb + 1);
    tbtop = tbp = (struct tty_buf *) (lb + stats.ledbufs);
    fprintf(ofp,"lbsize = %d, lbbase = %08X, lbfree = %08X\n",
	cb->lbsize,cb->lbbase,cb->lbfree);
    fprintf(ofp,"tbsize = %d, tbbase = %08X, tbfree = %08X, tbused = %08X\n",
	cb->tbsize,cb->tbbase,cb->tbfree,cb->tbused);
    fprintf(ofp,"   local lbfree = %08X(%2d), tbfree = %08X(%2d), tbused = %08X(%2d)\n",
	cb->lbfree ? lbtop + (cb->lbfree - cb->lbbase) : 0,cb->lbfree ? cb->lbfree - cb->lbbase : 0,
	cb->tbfree ? tbtop + (cb->tbfree - cb->tbbase) : 0,cb->tbfree ? cb->tbfree - cb->tbbase : 0,
	cb->tbused ? tbtop + (cb->tbused - cb->tbbase) : 0,cb->tbused ? cb->tbused - cb->tbbase : 0);
    for (cnt = 0; cnt < stats.ttybufs; ++cnt,++tbp)
    {
	fprintf(ofp,"\n**************** tty_buf %2d (%X) ***************\n",
	    cnt,tbp);
	tbp->next = tbtop + (tbp->next - cb->tbbase);
	tbp->last = tbtop + (tbp->last - cb->tbbase);
	tbp->lbp = tbp->lbp ? (lbtop + (tbp->lbp - cb->lbbase)) : 0;
	fprintf(ofp,"Next - %08X(%2d), Last - %08X(%2d), lbtop - %08X(%2d)\n",
	    tbp->next,tbp->next - tbtop,
	    tbp->last,tbp->last - tbtop,
	    tbp->lbp,tbp->lbp ? tbp->lbp - lbtop : 0);
	fprintf(ofp,"BC.c_cc - %d, flags = %02X, tty - %08X\n",
	    tbp->broadcast.c_cc,tbp->flags,tbp->ttyp);
	fprintf(ofp,"refresh = %d, readsleep = %d, tclen = %d\n",
	    tbp->dorefresh,tbp->readsleep,tbp->tclen);
	fputs("*****************************************************\n",ofp);
	if (tbp->ttyp != 0)
	{
	    struct tty              *ttyp;

	    *(struct tty **) ttys = tbp->ttyp;
	    ttyp = (struct tty *) ttys;
	    if (ioctl(clp,LDGETTTY,ttyp) < 0)
	    {
		perror("Error getting tty struct");
	    }
	    else
	    {
		fputs("===================================================\n",ofp);
		fprintf(ofp,"rawq.c_cc = %d, canq.c_cc = %d, outq.c_cc = %d\n",
		    ttyp->t_rawq.c_cc,ttyp->t_canq.c_cc,ttyp->t_outq.c_cc);
		fprintf(ofp,"iflag = %04X, oflag = %04X, cflag = %04X, lflag = %04X\n",
		    ttyp->t_iflag,ttyp->t_oflag,ttyp->t_cflag,ttyp->t_lflag);
		fprintf(ofp,"state = %04X, pgrp = %d, line = %d, dstat = %04X\n",
		    ttyp->t_state,ttyp->t_pgrp,ttyp->t_line,ttyp->t_dstat);

#if defined(M_UNIX)
		fprintf(ofp,"xstate = %02X, merr = %02X, xmp = %08X\n",
		    ttyp->t_xstate,ttyp->t_merr,ttyp->t_mp);
#else
		fprintf(ofp,"xstate = %02X, xxx = %02X, merr = %02X, xmp = %08X\n",
		    ttyp->t_xstate,ttyp->t_xxx,ttyp->t_merr,ttyp->t_xmp);
#endif

		fprintf(ofp,"delct = %d\n",ttyp->t_delct);
		fputs("===================================================\n",ofp);
	    }
	}
    }
    for (cnt = 0; cnt < stats.ledbufs; ++cnt,++lb)
    {
	int                     comsiz,his,hsiz;

	fprintf(ofp,"\n**************** led_buf %2d (%X) ***************\n",
	    cnt,lb);

#if MULTI_LB
	lb->next = lbtop + (lb->next - cb->lbbase);
	lb->last = lbtop + (lb->last - cb->lbbase);
#endif

	lb->tbp = lb->tbp ? tbtop + (lb->tbp - cb->tbbase) : 0;

	fprintf(ofp,"Next - %08X(%2d), Last - %08X(%2d), ttybf - %08X(%2d)\n",

#if MULTI_LB
	    lb->next,lb->next - lbtop,
	    lb->last,lb->last - lbtop,
else
	    0l,0l,0l,0l,
#endif

	    lb->tbp,lb->tbp ? lb->tbp - tbtop : 0);
	fprintf(ofp,"Proc - %08X, pid = %d, ppid = %d, flags = %04X\n",

#if MULTI_LB
	    lb->proc,lb->pid,lb->ppid,lb->flags);
#else
	    0l,0,0,lb->flags);
#endif

	fprintf(ofp,"State - %04X, last char - %04X, prompt_size = %d\n",
	    lb->state,lb->c,lb->promptlen);
	hsiz = his = comsiz = 0;
	{
	    unchar                  *hp,*hpend;

	    hp = lb->history + 1;
	    hpend = lb->history + sizeof lb->history
		- (unchar *) cb->lbbase + (unchar *) lbtop;
	    comsiz = hpend - lb->history;
	    while (*hp != 0 && hp < hpend)
	    {
		++his;
		hsiz += *hp;
		hp += *hp;
	    }
	    if (hp >= hpend)
		fprintf(ofp,"Warning: history buffer overlaps keydefs\n");
	}
	fprintf(ofp,"current = %d, lastchar = %d, comsize = %d, his_size = %d, h_lines = %d\n",
	    lb->current,lb->lastchar,comsiz,hsiz,his);
	fprintf(ofp,"amt owed = %d\n",lb->owed ? lb->lcurs - lb->owed : 0);
	fputs("*****************************************************\n",ofp);
    }
    fclose(ofp);
    close(clp);
    exit(0);
}
