/*
    $Id: cledio.h,v 2.5 90/08/26 11:35:00 sw Exp $
*/

/*
    CLED will be active only if this options are set
*/

#define CLEDFLAGS	(ICANON|ECHO|ECHOE|ECHOK)

/*
    Terminal capabilities remembered by CLED
*/

#define TCAP_CLREOL_STR		"\033[K"	/* clear to eol		*/
#define TCAP_SETINV_STR		"\033[7m"	/* set inverse video	*/
#define TCAP_SETNORM_STR	"\033[m"	/* set normal video	*/
#define TCAP_SAVE_STR		"\0337"		/* save cursor pos and attr */
#define TCAP_RESTORE_STR	"\0338"		/* restore pos and attr	*/
#define TCAP_FLASH_STR		"\007"		/* ring bell or similar	*/

#define TCAP_CLREOL	0
#define TCAP_SETINV	1
#define TCAP_SETNORM	2
#define TCAP_SAVE	3
#define TCAP_RESTORE	4
#define TCAP_FLASH	5
#define TCAP_COUNT	6			/* last one indicates total */

/*
    ioctl codes available
*/

#define LDIOC	    ('D'<<8)

/*
    Ioctls on the line discipline itself
*/

#define LDGETCOLS   (LDIOC|14)	    /* Get terminal line length		*/
#define LDSETCOLS   (LDIOC|15)	    /* Set terminal line length		*/

#define LDGETBF	    (LDIOC|16)	    /* get bindings & capabilities	*/
#define LDSETBF	    (LDIOC|17)	    /* set bindings & capabilities	*/

#define LDGETHB	    (LDIOC|18)	    /* get history buffer		*/
#define LDSETHB	    (LDIOC|19)	    /* set history buffer		*/

/*
    Ioctls on the CLED driver in general
*/

#define LDGETS	    (LDIOC|20)	    /* get cled stats			*/

#define LDGETB	    (LDIOC|21)	    /* dump its guts (debug mode only)	*/
#define LDGETTTY    (LDIOC|22)	    /* dump a tty struct (debug mode only) */
#define LDGETC	    (LDIOC|23)	    /* dump contents of a clist (debug only) */

/*
    Error codes returned from ioctl functions
*/

#define ERR_NOTTYBUF	12	    /* ENOMEM no more ttybufs available */
#define ERR_NOLEDBUF	11	    /* EAGAIN no more ledbufs available */
#define ERR_NOLBASS	19	    /* ENODEV no led buf assigned to process */
#define ERR_BADPARAM	22	    /* EINVAL bad paramater value */
#define ERR_BADIOCTL	33	    /* EDOM bad ioctl function */

/*
    Pass the address of this struct to LDGETS
*/

struct cle_stats
{
    int		    ledbufs;	    /* max number of led_buffers	*/
    int		    ttybufs;	    /* max number of tty_buffers	*/
    int		    promptsize;	    /* size of prompt buffer		*/
    int		    linesize;	    /* size of command buffer		*/
    int		    histsize;	    /* size of history buffer		*/
    int		    multi_lb;	    /* t/f flag indicating multi-lb mode */
    int		    spt;	    /* t/f flag indicating using sptalloc */
    int		    tcapsize;	    /* max length of all ascii strings	*/
    int		    ledbufs_used;   /* number of led_buf's in use	*/
    int		    ttybufs_used;   /* number of tty_buf's in use	*/
    int		    line;	    /* cled's line discipline number	*/
    char	    vers[4];	    /* version #			*/
};

/*
    Pass the address of this struct to LDGETB/LDSETB
*/

struct cle_buf
{
    int		    lbsize;
    int		    tbsize;
    struct led_buf  *lbbase;
    struct led_buf  *lbfree;
    struct tty_buf  *tbbase;
    struct tty_buf  *tbused;
    struct tty_buf  *tbfree;
    struct proc	    *procbase;
};

/*
    Pass this struct for LDGETF/LDSETF.

    The following structure is passed to the ioctl routine to
    /dev/cled to assign the key bindings and the TCAP sequences
    (and other strings) desired for various functions.

    If the ioctl completes with an error, then the len fields of
    the struct will have been changed to an index into the
    respective buffer at which the error occured (the driver sets
    the value).

    The key buffer immediately follows the set_key struct and the
    TCAP buffer immediately follows the key buffer.

    The key buffer contains pairs of chars; the first is the key
    number and the second is the function number.  The kdbuf_len
    entry in the set_key struct contains the total number of these
    pairs of chars.  Any of the control keys and/or keypad keys can
    be set to any function at any time.  New definitions replace
    previous definitions.  Keys not explicitly defined in the
    buffer are left defined to whatever they were.

    The TCAP buffer consists of a stream of null terminated strings
    preceeded by the number of the sequence to which the string
    belongs.  If any TCAP sequence is defined, then ALL the
    sequences are first reset to their defaults and then replaced
    with the new definitions.  That is, you can change one or all,
    but unlike the key definitions, you cannot change just one
    without affecting all the others.
*/

struct set_key
{
    int                     modes;	    /* default mode bits	    */
    int                     kdbuf_len;	    /* key buffer length (in items) */
    int                     tcapbuf_len;    /* length of escapes (in chars) */
};

/*
    We implement a very contrived set of key bindings; we have
    the 32 control characters, then 96 meta characters, then
    DEL. We don't provide for bindint to x or M-C-x, only
    either C-x or M-x.

    To bind to M-x, use CLEKEY_ESC(x), to bind to C-x, use CLEKEY_CTL(x).
*/

#define CLEKEY_CHAR(c)	((c) >= ' ' && (c) <= '~')

#define CLEKEY_CMD(c)	((c)&0x7F)
#define CLEKEY_ESC(c)	((c)&0x7F)
#define CLEKEY_CTL(c)	((c)&0x1F)
#define CLEKEY_DEL	0x7F

#define CLEKEY_MAX	0x80

/*
    default modes
*/

#define CLEMODE_INSERT	0x01	/* insert mode */
#define CLEMODE_OVER    0x02	/* overstrike mode */

/*
    Editor functions: (don't change the order of these)
*/

#define CLEFUN_CHAR	0x00	/* insert character into buffer		*/
#define CLEFUN_INSERT	0x01	/* toggle insert/overstrike mode	*/
#define CLEFUN_GOTOBOL	0x02	/* goto beginning of line		*/
#define CLEFUN_GOTOEOL	0x03	/* goto end of line			*/
#define CLEFUN_DELWLFT	0x04	/* delete word to left of cursor	*/
#define CLEFUN_DELWRIT	0x05	/* delete word to right of cursor	*/
#define CLEFUN_DELBOL	0x06	/* delete from cursor to beginning of line */
#define CLEFUN_DELEOL	0x07	/* delete from cursor to end of line	*/
#define CLEFUN_CURSL	0x08	/* move cursor left 1 position		*/
#define CLEFUN_CURSR	0x09	/* move cursor right 1 position		*/
#define CLEFUN_DELCLFT	0x0A	/* delete char left of cursor		*/
#define CLEFUN_DELCRIT	0x0B	/* delete char under cursor		*/
#define CLEFUN_REFRESH	0x0C	/* reprint the current line		*/
#define CLEFUN_PREVIOUS	0x0D	/* recall previous command		*/
#define CLEFUN_NEXT	0x0E	/* recall next command			*/
#define CLEFUN_FIND	0x0F	/* find matching string			*/
#define CLEFUN_NEWLINE	0x10	/* end of line				*/
#define CLEFUN_ESCAPE	0x11	/* "escape" the next character		*/
#define CLEFUN_NOP	0x12	/* nop					*/
#define CLEFUN_BELL	0x13	/* ring bell				*/
#define CLEFUN_SKIPWL	0x14	/* skip word left			*/
#define CLEFUN_SKIPWR	0x15	/* skip word right			*/
#define CLEFUN_PURGE	0x16	/* purge all typeahead			*/
#define CLEFUN_META	0x17	/* access chars with 8th bit on		*/
#define CLEFUN_ANSI	0x18	/* parse ansi cursor sequence		*/
#define CLEFUN_MAX	0x19	/* number of functions			*/
